/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.actions.settings.get;

import com.floragunn.codova.documents.DocWriter;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.signals.Signals;
import com.floragunn.signals.actions.settings.get.GetSettingsRequest;
import com.floragunn.signals.actions.settings.get.GetSettingsResponse;
import com.floragunn.signals.settings.SignalsSettings;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.json.JsonXContent;

public class TransportGetSettingsAction
extends HandledTransportAction<GetSettingsRequest, GetSettingsResponse> {
    private static final Logger log = LogManager.getLogger(TransportGetSettingsAction.class);
    private final Signals signals;

    @Inject
    public TransportGetSettingsAction(Signals signals, TransportService transportService, ThreadPool threadPool, ActionFilters actionFilters, Client client) {
        super("cluster:admin:searchguard:signals:settings/get", transportService, actionFilters, GetSettingsRequest::new);
        this.signals = signals;
    }

    protected final void doExecute(Task task, GetSettingsRequest request, ActionListener<GetSettingsResponse> listener) {
        try {
            Settings settings = this.signals.getSignalsSettings().getDynamicSettings().getSettings();
            if (request.getKey() == null) {
                listener.onResponse((Object)new GetSettingsResponse(GetSettingsResponse.Status.OK, this.asJson(settings), "application/json"));
            } else {
                SignalsSettings.ParsedSettingsKey parsedKey = SignalsSettings.DynamicSettings.matchSetting(request.getKey());
                Object value = this.getValue(parsedKey, settings);
                if (log.isDebugEnabled()) {
                    log.debug("parsedKey: " + parsedKey + "; value: " + value + "; r: " + settings.get(request.getKey()));
                }
                if (!request.isJsonRequested() && (value instanceof String || value instanceof Number || value instanceof Boolean)) {
                    listener.onResponse((Object)new GetSettingsResponse(GetSettingsResponse.Status.OK, String.valueOf(value), "text/plain"));
                } else {
                    String json = DocWriter.json().writeAsString(value);
                    listener.onResponse((Object)new GetSettingsResponse(GetSettingsResponse.Status.OK, json, "application/json"));
                }
            }
        }
        catch (ConfigValidationException e) {
            listener.onResponse((Object)new GetSettingsResponse(GetSettingsResponse.Status.NOT_FOUND, e.getMessage(), null));
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    private String asJson(Settings settings) {
        try {
            ToXContent.MapParams params = new ToXContent.MapParams((Map)ImmutableMap.of((Object)SettingsFilter.SETTINGS_FILTER_PARAM, (Object)"internal_auth.*"));
            XContentBuilder builder = JsonXContent.contentBuilder();
            builder.startObject();
            settings.toXContent(builder, (ToXContent.Params)params);
            builder.endObject();
            return BytesReference.bytes((XContentBuilder)builder).utf8ToString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Object getValue(SignalsSettings.ParsedSettingsKey parsedKey, Settings settings) {
        if (parsedKey.isGroup()) {
            Settings group = settings.getByPrefix(parsedKey.setting.getKey() + parsedKey.groupName);
            return parsedKey.getSubSetting().get(group);
        }
        return parsedKey.getSetting().get(settings);
    }
}

